/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util.panels;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class FileTree
extends JTree {
    private File currentDirectory;
    private String[] children;

    public FileTree() {
        this(new File(System.getProperty("user.dir")), null);
    }

    public FileTree(File file, FilenameFilter filenameFilter) {
        this.currentDirectory = file;
        this.setModel(new FileSystemModel(file, filenameFilter));
        this.setEditable(true);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                File file = (File)FileTree.this.getLastSelectedPathComponent();
                if (file.isDirectory()) {
                    FileTree.this.currentDirectory = file;
                } else {
                    FileTree.this.currentDirectory = file.getParentFile();
                }
                FileTree.this.onSelectFile(file);
            }
        });
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String[] getChildren() {
        return this.children;
    }

    public abstract void onSelectFile(File var1);

    static /* synthetic */ String[] access$102(FileTree fileTree, String[] stringArray) {
        fileTree.children = stringArray;
        return stringArray;
    }

    class DirAlphaComparator
    implements Comparator<String> {
        DirAlphaComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }

    class FileSystemModel
    implements TreeModel {
        Comparator<String> byDirThenAlpha;
        private File root;
        private FilenameFilter filter;
        private Vector<TreeModelListener> listeners;

        public FileSystemModel(File file, FilenameFilter filenameFilter) {
            this.byDirThenAlpha = new DirAlphaComparator();
            this.listeners = new Vector();
            this.root = file;
            this.filter = filenameFilter;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public Object getChild(Object object, int n) {
            File file = (File)object;
            FileTree.access$102(FileTree.this, file.list(this.filter));
            Arrays.sort(FileTree.this.children, this.byDirThenAlpha);
            return new TreeFile(file, FileTree.this.children[n]);
        }

        @Override
        public int getChildCount(Object object) {
            String[] stringArray;
            File file = (File)object;
            if (file.isDirectory() && (stringArray = file.list(this.filter)) != null) {
                return stringArray.length;
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object object) {
            File file = (File)object;
            return file.isFile();
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            File file = (File)object;
            File file2 = (File)object2;
            FileTree.access$102(FileTree.this, file.list(this.filter));
            Arrays.sort(FileTree.this.children, this.byDirThenAlpha);
            for (int i = 0; i < FileTree.this.children.length; ++i) {
                if (!file2.getName().equals(FileTree.this.children[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
            File file = (File)treePath.getLastPathComponent();
            String string = file.getParent();
            String string2 = (String)object;
            File file2 = new File(string, string2);
            file.renameTo(file2);
            File file3 = new File(string);
            int[] nArray = new int[]{this.getIndexOfChild(file3, file2)};
            Object[] objectArray = new Object[]{file2};
            this.fireTreeNodesChanged(treePath.getParentPath(), nArray, objectArray);
        }

        private void fireTreeNodesChanged(TreePath treePath, int[] nArray, Object[] objectArray) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
            for (TreeModelListener treeModelListener : this.listeners) {
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.remove(treeModelListener);
        }

        private class TreeFile
        extends File {
            public TreeFile(File file, String string) {
                super(file, string);
            }

            @Override
            public String toString() {
                return this.getName();
            }
        }
    }
}

