/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util.panels;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import ac.essex.ooechs.imaging.commons.util.panels.ScalingImagePanel;
import java.awt.Container;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;

public class ImageFrame
extends JFrame {
    public static final String DEFAULT_TITLE = "Image Viewer";
    public ImagePanel imagePanel;

    public ImageFrame(PixelLoader pixelLoader) {
        this(null, pixelLoader.getBufferedImage(), null);
    }

    public ImageFrame(JFrame jFrame, PixelLoader pixelLoader) {
        this(jFrame, pixelLoader.getBufferedImage(), null);
    }

    public ImageFrame(BufferedImage bufferedImage) {
        this(null, bufferedImage, null);
    }

    public ImageFrame(BufferedImage bufferedImage, String string) {
        this(null, bufferedImage, string);
    }

    public ImageFrame(JFrame jFrame, BufferedImage bufferedImage, String string) {
        super(string == null ? DEFAULT_TITLE : string);
        Container container = this.getContentPane();
        this.imagePanel = new ScalingImagePanel();
        this.imagePanel.setImage(bufferedImage);
        this.imagePanel.setDisplayCentered(true);
        container.add(this.imagePanel);
        if (jFrame == null) {
            this.setDefaultCloseOperation(3);
        }
        this.setSize(bufferedImage.getWidth() + 100, bufferedImage.getHeight() + 100);
        this.setVisible(true);
        try {
            new PixelLoader(bufferedImage).saveAs("m:\\pc\\Desktop\\" + string + ".png");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

