/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util.panels;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    public int zoom = 1;
    public BufferedImage image;
    protected boolean setDisplayCentered = false;
    protected boolean scale = false;
    public boolean display = true;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public ImagePanel() {
    }

    public ImagePanel(PixelLoader pixelLoader) {
        this.setImage(pixelLoader);
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
        this.afterZoom();
        this.repaint();
    }

    public void setImage(PixelLoader pixelLoader) {
        this.setImage(pixelLoader.getBufferedImage());
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setDisplayCentered(boolean bl) {
        this.setDisplayCentered = bl;
        if (!bl) {
            this.offsetX = 0;
            this.offsetY = 0;
        }
    }

    public void setScaling(boolean bl) {
        this.scale = bl;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getX(MouseEvent mouseEvent) {
        return (mouseEvent.getX() - this.offsetX) / this.zoom;
    }

    public int getY(MouseEvent mouseEvent) {
        return (mouseEvent.getY() - this.offsetY) / this.zoom;
    }

    public void drawImage(Graphics graphics, BufferedImage bufferedImage) {
        if (!this.scale) {
            graphics.drawImage(bufferedImage, this.offsetX, this.offsetY, bufferedImage.getWidth() * this.zoom, bufferedImage.getHeight() * this.zoom, this);
        } else {
            graphics.drawImage(bufferedImage, 0, 0, this.getWidth(), this.getHeight(), this);
        }
    }

    public void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawRect((n + this.offsetX) * this.zoom, (n2 + this.offsetX) * this.zoom, n3 * this.zoom, n4 * this.zoom);
    }

    public void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.fillRect((n + this.offsetX) * this.zoom, (n2 + this.offsetX) * this.zoom, n3 * this.zoom, n4 * this.zoom);
    }

    public void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine((n + this.offsetX) * this.zoom, (n2 + this.offsetX) * this.zoom, (n3 + this.offsetX) * this.zoom, (n4 + this.offsetX) * this.zoom);
    }

    protected void afterZoom() {
        if (this.image == null) {
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        } else {
            this.setPreferredSize(new Dimension(this.image.getWidth() * this.zoom, this.image.getHeight() * this.zoom));
        }
        this.revalidate();
    }

    public void zoomIn() {
        this.zoom += 2;
        if (this.zoom > 32) {
            this.zoom = 32;
        }
        this.afterZoom();
    }

    public void zoomOut() {
        this.zoom -= 2;
        if (this.zoom < 1) {
            this.zoom = 1;
        }
        this.afterZoom();
    }

    public void setImageNull() {
        this.image = null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.image != null) {
            if (this.setDisplayCentered) {
                this.offsetX = (this.getWidth() - this.image.getWidth() * this.zoom) / 2;
                this.offsetY = (this.getHeight() - this.image.getHeight() * this.zoom) / 2;
            }
            if (this.display) {
                graphics.setColor(Color.BLACK);
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.drawImage(graphics, this.image);
            }
        } else {
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

