/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.util.panels;

import ac.essex.ooechs.imaging.commons.grids.Grid;
import ac.essex.ooechs.imaging.commons.util.Region;
import ac.essex.ooechs.imaging.commons.util.panels.ScalingImagePanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class ScalingGridPanel
extends ScalingImagePanel {
    Grid grid;
    public int x = 0;
    public int y = 0;

    public ScalingGridPanel(Grid grid) {
        this.grid = grid;
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                int n = ScalingGridPanel.this.getWidth() / ScalingGridPanel.this.grid.getTotalHorizontalLines();
                int n2 = ScalingGridPanel.this.getHeight() / ScalingGridPanel.this.grid.getTotalVerticalLines();
                int n3 = mouseEvent.getX() / n;
                int n4 = mouseEvent.getY() / n2;
                if (ScalingGridPanel.this.x != n3 || ScalingGridPanel.this.y != n4) {
                    ScalingGridPanel.this.x = n3;
                    ScalingGridPanel.this.y = n4;
                    ScalingGridPanel.this.repaint();
                }
            }
        });
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Region region = new Region(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.WHITE);
        this.grid.draw(graphics, region);
        int n = this.getWidth() / this.grid.getTotalHorizontalLines();
        int n2 = this.getHeight() / this.grid.getTotalVerticalLines();
        graphics.setColor(Color.BLACK);
        graphics.drawRect(this.x * n, this.y * n2, n, n2);
        double d = ((double)this.x + 0.1) * (double)n;
        double d2 = ((double)this.y + 0.7) * (double)n2;
        graphics.drawString(this.x + ", " + this.y, (int)d, (int)d2);
    }
}

