/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.video;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;

public class FrameAccess
implements ControllerListener {
    Processor p;
    Object waitSync = new Object();
    boolean stateTransitionOK = true;
    public boolean alreadyPrnt = false;

    public boolean open(MediaLocator mediaLocator) {
        try {
            this.p = Manager.createProcessor((MediaLocator)mediaLocator);
        }
        catch (Exception exception) {
            System.err.println("Failed to create a processor from the given url: " + exception);
            return false;
        }
        this.p.addControllerListener((ControllerListener)this);
        this.p.configure();
        if (!this.waitForState(180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        this.p.setContentDescriptor(null);
        TrackControl[] trackControlArray = this.p.getTrackControls();
        if (trackControlArray == null) {
            System.err.println("Failed to obtain track controls from the processor.");
            return false;
        }
        TrackControl trackControl = null;
        for (int i = 0; i < trackControlArray.length; ++i) {
            if (trackControlArray[i].getFormat() instanceof VideoFormat) {
                trackControl = trackControlArray[i];
                continue;
            }
            trackControlArray[i].setEnabled(false);
        }
        if (trackControl == null) {
            System.err.println("The input media does not contain a video track.");
            return false;
        }
        String string = trackControl.getFormat().toString();
        Dimension dimension = this.parseVideoSize(string);
        System.err.println("Video format: " + string);
        try {
            Codec[] codecArray = new Codec[]{new PostAccessCodec(dimension)};
            trackControl.setCodecChain(codecArray);
        }
        catch (UnsupportedPlugInException unsupportedPlugInException) {
            System.err.println("The process does not support effects.");
        }
        this.p.prefetch();
        if (!this.waitForState(500)) {
            System.err.println("Failed to realise the processor.");
            return false;
        }
        this.p.start();
        return true;
    }

    public Dimension parseVideoSize(String string) {
        int n = 300;
        int n2 = 200;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "x");
        try {
            n = Integer.parseInt(stringTokenizer2.nextToken());
            n2 = Integer.parseInt(stringTokenizer2.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("unable to find video size, assuming default of 300x200");
        }
        System.out.println("Image width  = " + String.valueOf(n) + "\nImage height = " + String.valueOf(n2));
        return new Dimension(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int n) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (this.p.getState() != n && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent controllerEvent) {
        if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (controllerEvent instanceof EndOfMediaEvent) {
            this.p.close();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        FrameAccess frameAccess;
        String string = "file:///home/ooechs/Desktop/pipelines.mpg";
        MediaLocator mediaLocator = new MediaLocator(string);
        if (mediaLocator == null) {
            System.err.println("Cannot build media locator from: " + string);
            System.exit(0);
        }
        if (!(frameAccess = new FrameAccess()).open(mediaLocator)) {
            System.exit(0);
        }
    }

    public class PostAccessCodec
    extends PreAccessCodec {
        private Dimension size;

        public PostAccessCodec(Dimension dimension) {
            this.supportedIns = new Format[]{new RGBFormat()};
            this.size = dimension;
        }

        @Override
        void accessFrame(Buffer buffer) {
            if (!FrameAccess.this.alreadyPrnt) {
                BufferToImage bufferToImage = new BufferToImage((VideoFormat)buffer.getFormat());
                Image image = bufferToImage.createImage(buffer);
                try {
                    BufferedImage bufferedImage = new BufferedImage(this.size.width, this.size.height, 1);
                    Graphics graphics = bufferedImage.getGraphics();
                    graphics.drawImage(image, 0, 0, this.size.width, this.size.height, null);
                    Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
                    ImageWriter imageWriter = iterator.next();
                    File file = new File(buffer.getSequenceNumber() + ".jpg");
                    ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);
                    imageWriter.setOutput(imageOutputStream);
                    imageWriter.write(bufferedImage);
                    imageOutputStream.close();
                }
                catch (IOException iOException) {
                    System.out.println("Error :" + iOException);
                }
            }
            long l = (long)((float)buffer.getTimeStamp() / 1.0E7f);
            System.err.println("Post: frame #: " + buffer.getSequenceNumber() + ", time: " + (float)l / 100.0f + ", len: " + buffer.getLength());
        }

        @Override
        public String getName() {
            return "Post-Access Codec";
        }
    }

    public class PreAccessCodec
    implements Codec {
        protected Format[] supportedIns = new Format[]{new VideoFormat(null)};
        protected Format[] supportedOuts = new Format[]{new VideoFormat(null)};
        Format input = null;
        Format output = null;

        void accessFrame(Buffer buffer) {
            long l = (long)((float)buffer.getTimeStamp() / 1.0E7f);
            System.err.println("Pre: frame #: " + buffer.getSequenceNumber() + ", time: " + (float)l / 100.0f + ", len: " + buffer.getLength());
        }

        public String getName() {
            return "Pre-Access Codec";
        }

        public void open() {
        }

        public void close() {
        }

        public void reset() {
        }

        public Format[] getSupportedInputFormats() {
            return this.supportedIns;
        }

        public Format[] getSupportedOutputFormats(Format format) {
            if (format == null) {
                return this.supportedOuts;
            }
            Format[] formatArray = new Format[]{format};
            return formatArray;
        }

        public Format setInputFormat(Format format) {
            this.input = format;
            return this.input;
        }

        public Format setOutputFormat(Format format) {
            this.output = format;
            return this.output;
        }

        public int process(Buffer buffer, Buffer buffer2) {
            this.accessFrame(buffer);
            Object object = buffer.getData();
            buffer.setData(buffer2.getData());
            buffer2.setData(object);
            buffer2.setFlags(96);
            buffer2.setFormat(buffer.getFormat());
            buffer2.setLength(buffer.getLength());
            buffer2.setOffset(buffer.getOffset());
            return 0;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String string) {
            return null;
        }
    }
}

