/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.watershed;

import ac.essex.ooechs.imaging.commons.Pixel;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Stack;
import java.util.Vector;
import javax.imageio.ImageIO;

public class WatershedAlgorithm {
    protected PixelLoader image;
    public Vector<PixelGroup> groups;
    public int minGroupSize;
    protected int[][] data;
    protected int groupIDCounter = 1;

    public static void main(String[] stringArray) throws Exception {
        WatershedAlgorithm watershedAlgorithm = new WatershedAlgorithm(new PixelLoader("/home/ooechs/Desktop/unionjack1.jpg"));
        watershedAlgorithm.process(10);
    }

    public WatershedAlgorithm(PixelLoader pixelLoader) {
        int n;
        this.image = pixelLoader;
        this.data = new int[pixelLoader.getWidth()][pixelLoader.getHeight()];
        int n2 = pixelLoader.getHeight() - 1;
        for (n = 0; n < pixelLoader.getWidth(); ++n) {
            this.data[n][0] = -1;
            this.data[n][n2] = -1;
        }
        n = pixelLoader.getWidth() - 1;
        for (int i = 0; i < pixelLoader.getHeight(); ++i) {
            this.data[0][i] = -1;
            this.data[n][i] = -1;
        }
        this.groups = new Vector(10);
        this.minGroupSize = (int)((double)(pixelLoader.getWidth() * pixelLoader.getHeight()) * 0.001);
        System.out.println("Min Group Size: " + this.minGroupSize);
    }

    public void process(int n) {
        System.out.println("Churning Watershed Algorithm");
        long l = System.currentTimeMillis();
        for (int i = n; i < 255; i += n) {
            if (this.groups.size() > 0) {
                for (int j = 0; j < this.groups.size(); ++j) {
                    PixelGroup pixelGroup = this.groups.elementAt(j);
                    this.grow(pixelGroup, i);
                }
            }
            this.findNewGroups(i);
            this.draw("/home/ooechs/Desktop/frame" + i + ".png");
        }
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Processed in: " + l2 + "ms.");
        System.out.println("Groups: " + this.groups.size());
    }

    public void findNewGroups(int n) {
        for (int i = 1; i < this.image.getHeight() - 2; ++i) {
            for (int j = 1; j < this.image.getWidth() - 2; ++j) {
                int n2;
                if (this.data[j][i] != 0 || (n2 = this.image.getGreyValue(j, i)) > n) continue;
                PixelGroup pixelGroup = new PixelGroup(this.groupIDCounter, j, i);
                this.data[j][i] = this.groupIDCounter++;
                this.expand(j, i, n, pixelGroup);
                if (pixelGroup.pixels.size() > this.minGroupSize) {
                    this.groups.add(pixelGroup);
                    continue;
                }
                for (int k = 0; k < pixelGroup.pixels.size(); ++k) {
                    Pixel pixel = pixelGroup.pixels.elementAt(k);
                    this.data[pixel.x][pixel.y] = 0;
                }
            }
        }
    }

    public void grow(PixelGroup pixelGroup, int n) {
        for (int i = 0; i < pixelGroup.pixels.size(); ++i) {
            Pixel pixel = pixelGroup.pixels.elementAt(i);
            this.expand(pixel.x, pixel.y, n, pixelGroup);
        }
    }

    public void expand(int n, int n2, int n3, PixelGroup pixelGroup) {
        Stack<Pixel> stack = new Stack<Pixel>();
        stack.push(new Pixel(n, n2));
        while (stack.size() > 0) {
            Pixel pixel = (Pixel)stack.pop();
            this.expand(pixel.x, pixel.y, n3, pixelGroup, stack);
        }
    }

    private void expand(int n, int n2, int n3, PixelGroup pixelGroup, Stack<Pixel> stack) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (j != 0 && i != 0 || this.data[n + j][n2 + i] != 0 || this.image.getGreyValue(n + j, n2 + i) > n3) continue;
                stack.push(pixelGroup.add(n + j, n2 + i));
            }
        }
    }

    private boolean isEdgePixel(int n, int n2, int n3) {
        return this.data[n][n2 - 1] != n3 || this.data[n - 1][n2] != n3 || this.data[n][n2 + 1] != n3 || this.data[n + 1][n2] != n3;
    }

    public void draw(String string) {
        int n = new Color(255, 0, 0).getRGB();
        int n2 = new Color(0, 255, 0).getRGB();
        int n3 = new Color(0, 0, 255).getRGB();
        int n4 = new Color(255, 255, 0).getRGB();
        int n5 = new Color(45, 45, 100).getRGB();
        int n6 = new Color(255, 128, 30).getRGB();
        int n7 = Color.BLACK.getRGB();
        int[] nArray = new int[]{n, n2, n3, n4, n6, n5};
        try {
            BufferedImage bufferedImage = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
            int n8 = 0;
            int n9 = 0;
            for (int i = 0; i < this.groups.size(); ++i) {
                PixelGroup pixelGroup = this.groups.elementAt(i);
                if (n8 >= nArray.length) {
                    n8 = 0;
                }
                Vector<Pixel> vector = pixelGroup.pixels;
                for (int j = 0; j < vector.size(); ++j) {
                    Pixel pixel = vector.elementAt(j);
                    if (this.isEdgePixel(pixel.x, pixel.y, pixelGroup.groupID)) {
                        bufferedImage.setRGB(pixel.x, pixel.y, n7);
                    } else {
                        bufferedImage.setRGB(pixel.x, pixel.y, nArray[n8]);
                    }
                    ++n9;
                }
                ++n8;
            }
            System.out.println("Drawn: " + n9 + " pixels.");
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class PixelGroup {
        protected Vector<Pixel> pixels;
        protected int groupID;

        public PixelGroup(int n, int n2, int n3) {
            this.groupID = n;
            this.pixels = new Vector(10);
            this.add(n2, n3);
        }

        public Pixel add(int n, int n2) {
            WatershedAlgorithm.this.data[n][n2] = this.groupID;
            Pixel pixel = new Pixel(n, n2);
            this.pixels.add(pixel);
            return pixel;
        }
    }
}

