/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.window.TheMondayProject;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.WindowData;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.trends.ChangeTrend;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.trends.RangeTrend;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.trends.StableTrend;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.trends.Trend;
import ac.essex.ooechs.imaging.commons.window.data.Window;
import ac.essex.ooechs.imaging.commons.window.util.WindowFeatures;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Collections;
import java.util.Vector;

public class MondayProject {
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int UNUSUAL = 3;
    Vector<WindowData> data;
    Vector<Trend> trends = new Vector();
    protected int maxX;

    public static void main(String[] stringArray) throws Exception {
        MondayProject mondayProject = new MondayProject();
        mondayProject.load("/home/ooechs/Desktop/pipes/Foreground/", 1);
        mondayProject.load("/home/ooechs/Desktop/pipes/Background/", 2);
        mondayProject.load("/home/ooechs/Desktop/pipes/Unusual/", 3);
        mondayProject.print(10, 1);
        mondayProject.print(10, 2);
        mondayProject.print(10, 3);
        mondayProject.findTrends();
        mondayProject.evaluateTrends();
        System.out.println("-------");
        System.out.println("True Data: ");
        mondayProject.evaluateData(1);
        System.out.println("-------");
        System.out.println("False Data: ");
        mondayProject.evaluateData(2);
        System.out.println("-------");
        System.out.println("Unusual Data: ");
        mondayProject.evaluateData(3);
        PixelLoader pixelLoader = mondayProject.createImage(50);
        pixelLoader.saveAs("/home/ooechs/Desktop/pipes/ranked.png");
    }

    public MondayProject() {
        this.data = new Vector();
    }

    public Vector<WindowData> getData(int n) {
        Vector<WindowData> vector = new Vector<WindowData>();
        for (int i = 0; i < this.data.size(); ++i) {
            WindowData windowData = this.data.elementAt(i);
            if (windowData.classID != n) continue;
            vector.add(windowData);
        }
        return vector;
    }

    public void print(int n, int n2) {
        Vector<WindowData> vector = this.getData(n2);
        for (int i = 0; i < n; ++i) {
            vector.elementAt((int)((double)vector.size() * Math.random())).print();
        }
    }

    public void load(String string, int n) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                try {
                    PixelLoader pixelLoader = new PixelLoader(file2);
                    Window window = new Window(pixelLoader.getWidth(), pixelLoader.getHeight(), 0, 0, null);
                    double[] dArray = WindowFeatures.getFeaturesForMonday(pixelLoader, window);
                    this.data.add(new WindowData(file2.getAbsolutePath(), dArray, n));
                    this.maxX = dArray.length;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void findTrends() {
        for (int i = 0; i < this.maxX; ++i) {
            for (int j = 0; j < 5; ++j) {
                try {
                    double d;
                    double d2;
                    FastStatistics fastStatistics = new FastStatistics();
                    FastStatistics fastStatistics2 = new FastStatistics();
                    for (int k = 0; k < this.data.size(); ++k) {
                        WindowData windowData = this.data.elementAt(k);
                        if (windowData.classID != 1) continue;
                        double[] dArray = windowData.data;
                        for (int i2 = 0; i2 < j; ++i2) {
                            fastStatistics.addData((float)dArray[i + i2]);
                        }
                        d2 = dArray[i];
                        d = dArray[i + j];
                        double d3 = d / d2 - 1.0;
                        fastStatistics2.addData((float)d3);
                    }
                    RangeTrend rangeTrend = new RangeTrend(i, j, fastStatistics.getMin(), fastStatistics.getMax());
                    this.addTrend(rangeTrend);
                    double d4 = fastStatistics2.getStandardDeviation();
                    d2 = fastStatistics2.getMean();
                    d = Double.MAX_VALUE;
                    ChangeTrend changeTrend = null;
                    for (double d5 = 0.0; d5 < d4 * 2.0; d5 += d4 / 10.0) {
                        ChangeTrend changeTrend2 = new ChangeTrend(i, j, d2, d5);
                        double d6 = this.getScore(changeTrend2);
                        if (!(d6 < d)) continue;
                        d = d6;
                        changeTrend = changeTrend2;
                    }
                    if (changeTrend != null && Math.abs(changeTrend.minChange) >= 0.05) {
                        this.addTrend(changeTrend);
                    }
                    StableTrend stableTrend = null;
                    for (double d7 = 0.0; d7 < d4 * 2.0; d7 += d4 / 10.0) {
                        StableTrend stableTrend2 = new StableTrend(i, j, d2, d7);
                        double d8 = this.getScore(stableTrend2);
                        if (!(d8 < d)) continue;
                        d = d8;
                        stableTrend = stableTrend2;
                    }
                    if (stableTrend == null) continue;
                    this.addTrend(stableTrend);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    public void addTrend(Trend trend) {
        double d = this.getMatchProbability(trend, 1);
        double d2 = this.getMatchProbability(trend, 2);
        if (d > 0.8 && d2 < 0.2) {
            this.trends.add(trend);
        }
    }

    public double getScore(Trend trend) {
        double d = this.getMatchProbability(trend, 1);
        double d2 = this.getMatchProbability(trend, 2);
        return 1.0 - d + d2;
    }

    public void evaluateTrends() {
        for (int i = 0; i < this.trends.size(); ++i) {
            Trend trend = this.trends.elementAt(i);
            double d = this.getMatchProbability(trend, 1);
            double d2 = this.getMatchProbability(trend, 2);
            trend.trueMatchProbability = d;
            System.out.println(i + ": " + d + ", " + d2);
        }
    }

    public void evaluateData(int n) {
        FastStatistics fastStatistics = new FastStatistics();
        for (int i = 0; i < this.data.size(); ++i) {
            WindowData windowData = this.data.elementAt(i);
            if (windowData.classID != n) continue;
            double[] dArray = windowData.data;
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < this.trends.size(); ++j) {
                Trend trend = this.trends.elementAt(j);
                if (trend.matches(dArray)) {
                    d += 1.0;
                    continue;
                }
                d2 += trend.trueMatchProbability;
            }
            fastStatistics.addData((float)d);
            windowData.rank = d;
        }
        System.out.println("Total trends: " + this.trends.size());
        System.out.println("Mean matches: " + fastStatistics.getMean());
        System.out.println("Std Deviation: " + fastStatistics.getStandardDeviation());
        System.out.println("Min: " + fastStatistics.getMin());
        System.out.println("Max: " + fastStatistics.getMax());
    }

    public PixelLoader createImage(int n) throws Exception {
        int n2 = 5 * this.data.size();
        System.out.println("Creating Image: " + n + "x" + n2);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics graphics = bufferedImage.getGraphics();
        int n3 = 0;
        Collections.sort(this.data);
        for (int i = 0; i < this.data.size(); ++i) {
            WindowData windowData = this.data.elementAt(i);
            PixelLoader pixelLoader = new PixelLoader(windowData.file);
            graphics.drawImage(pixelLoader.getBufferedImage(), 0, n3, null);
            n3 += pixelLoader.getHeight();
        }
        return new PixelLoader(bufferedImage);
    }

    public double getMatchProbability(Trend trend, int n) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            WindowData windowData = this.data.elementAt(i);
            if (windowData.classID != n) continue;
            double[] dArray = windowData.data;
            if (trend.matches(dArray)) {
                ++n2;
            }
            ++n3;
        }
        return (double)n2 / (double)n3;
    }
}

