/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.window.TheMondayProject.tuesday;

import ac.essex.ooechs.imaging.commons.fast.FastStatistics;
import ac.essex.ooechs.imaging.commons.signal.SignalFeature;
import ac.essex.ooechs.imaging.commons.signal.SignalProcessor;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.MondayProject;
import ac.essex.ooechs.imaging.commons.window.TheMondayProject.WindowData;
import java.util.Vector;

public class TrendClassifier {
    public static void main(String[] stringArray) throws Exception {
        MondayProject mondayProject = new MondayProject();
        mondayProject.load("/home/ooechs/Desktop/pipes/Foreground/", 1);
        mondayProject.load("/home/ooechs/Desktop/pipes/Background/", 2);
        mondayProject.load("/home/ooechs/Desktop/pipes/Unusual/", 3);
        new TrendClassifier(mondayProject);
    }

    public TrendClassifier(MondayProject mondayProject) {
        Vector<WindowData> vector = mondayProject.getData(1);
        System.out.println("True data:");
        this.test(vector);
        System.out.println("False data:");
        vector = mondayProject.getData(2);
        this.test(vector);
        System.out.println("Unusual data:");
        vector = mondayProject.getData(3);
        this.test(vector);
    }

    public void test(Vector<WindowData> vector) {
        int n;
        int[] nArray = new int[5];
        int n2 = 0;
        FastStatistics fastStatistics = new FastStatistics();
        for (n = 0; n < vector.size(); ++n) {
            WindowData windowData = vector.elementAt(n);
            SignalProcessor signalProcessor = new SignalProcessor(windowData.data);
            int n3 = 0;
            if (this.rule1(signalProcessor)) {
                ++n3;
            }
            if (this.rule2(signalProcessor)) {
                ++n3;
            }
            if (this.rule3(signalProcessor)) {
                ++n3;
            }
            if (this.rule4(signalProcessor)) {
                ++n3;
            }
            if (this.rule5(signalProcessor)) {
                ++n3;
            }
            fastStatistics.addData(n3);
            int n4 = n3 - 1;
            nArray[n4] = nArray[n4] + 1;
            ++n2;
        }
        System.out.println("Histogram:");
        for (n = 0; n < nArray.length; ++n) {
            int n5 = nArray[n];
            double d = (double)n5 / (double)n2;
            System.out.println(n + 1 + ", " + d);
        }
    }

    public boolean rule1(SignalProcessor signalProcessor) {
        return signalProcessor.getPeaks(0, 49, 200.0).size() >= 2;
    }

    public boolean rule1a(SignalProcessor signalProcessor) {
        return signalProcessor.getPeaks(15, 35, 200.0).size() == 2;
    }

    public boolean rule2(SignalProcessor signalProcessor) {
        Vector<SignalFeature> vector = signalProcessor.getPeaks(0, 49, 200.0);
        return SignalProcessor.getMaxWidth(vector) < 5;
    }

    public boolean rule3(SignalProcessor signalProcessor) {
        Vector<SignalFeature> vector = signalProcessor.getPeaks(0, 49, 200.0);
        return SignalProcessor.getHeightRange(vector) < 16.0;
    }

    public boolean rule4(SignalProcessor signalProcessor) {
        Vector<SignalFeature> vector = signalProcessor.getTroughs(0, 49, 100.0);
        return SignalProcessor.getMaxWidth(vector) < 10;
    }

    public boolean rule5(SignalProcessor signalProcessor) {
        return signalProcessor.getPeaks(0, 49, 150.0).size() == signalProcessor.getPeaks(0, 49, 200.0).size();
    }
}

