/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.window;

import ac.essex.ooechs.imaging.commons.ImageWindow;
import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.CSVWriter;
import ac.essex.ooechs.imaging.commons.util.ImageFilenameFilter;
import ac.essex.ooechs.imaging.commons.util.panels.FileTree;
import ac.essex.ooechs.imaging.commons.util.panels.ImageFrame;
import ac.essex.ooechs.imaging.commons.window.WindowImagePanel;
import ac.essex.ooechs.imaging.commons.window.classifiers.PipelineClassifier;
import ac.essex.ooechs.imaging.commons.window.classifiers.WindowClassifier;
import ac.essex.ooechs.imaging.commons.window.data.Window;
import ac.essex.ooechs.imaging.commons.window.data.WindowClass;
import ac.essex.ooechs.imaging.commons.window.data.WindowImage;
import ac.essex.ooechs.imaging.commons.window.data.WindowProject;
import ac.essex.ooechs.imaging.commons.window.util.FeaturesFromDirectory;
import ac.essex.ooechs.imaging.commons.window.util.FileFilters;
import ac.essex.ooechs.imaging.commons.window.util.WindowFeatures;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class WindowGUI
extends JFrame
implements ActionListener {
    public static final String APP_NAME = "Window GUI (In Development)";
    public static final String DEFAULT_PROJECT_FILE_LOCATION = "/home/ooechs/Desktop/birds";
    public static final int FIXED_WINDOW_SIZE = 1;
    public static final int VARIABLE_WINDOW_SIZE = 2;
    public FileTree fileTree;
    WindowImagePanel imagePanel;
    JTextField windowWidth;
    JTextField windowHeight;
    JMenuItem fileNew;
    JMenuItem fileOpen;
    JMenuItem fileSave;
    JMenuItem fileSaveAs;
    JMenuItem fileGenerateFeatures;
    JMenuItem fileGenerateImages;
    JMenuItem fileGenerateFeaturesFromImages;
    JMenuItem fileExit;
    JMenuItem editClear;
    JMenuItem toolsTest;
    JMenuItem toolsGenerateBackgroundFeatures;
    WindowImage currentImage = null;
    WindowClass currentClass = null;
    WindowProject project = new WindowProject();
    JLabel status;
    JFileChooser fc;
    public int mode = 2;

    public static void main(String[] stringArray) {
        new WindowGUI();
    }

    public WindowGUI() {
        super(APP_NAME);
        if (this.project.classes != null && this.project.classes.size() > 0) {
            this.currentClass = this.project.classes.elementAt(0);
        }
        this.fc = new JFileChooser(DEFAULT_PROJECT_FILE_LOCATION);
        this.init();
    }

    public void init() {
        Container container = this.getContentPane();
        this.fileTree = new FileTree(new File(DEFAULT_PROJECT_FILE_LOCATION), new ImageFilenameFilter()){

            @Override
            public void onSelectFile(File file) {
                if (!file.isDirectory()) {
                    WindowGUI.this.selectFile(file);
                }
            }
        };
        this.imagePanel = new WindowImagePanel(this);
        JSplitPane jSplitPane = new JSplitPane(1, true, new JScrollPane(this.fileTree), new JScrollPane(this.imagePanel));
        container.add(jSplitPane);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new JLabel("Width: "));
        this.windowWidth = new JTextField("50");
        jToolBar.add(this.windowWidth);
        jToolBar.add(new JLabel("Height: "));
        this.windowHeight = new JTextField("5");
        jToolBar.add(this.windowHeight);
        jToolBar.addSeparator();
        JComboBox jComboBox = new JComboBox(new EasyComboModel());
        jToolBar.add(new JLabel("Class: "));
        jToolBar.add(jComboBox);
        container.add((Component)jToolBar, "North");
        this.status = new JLabel(APP_NAME);
        container.add((Component)this.status, "South");
        JMenu jMenu = new JMenu("File");
        this.fileNew = new JMenuItem("New...");
        this.fileNew.addActionListener(this);
        this.fileOpen = new JMenuItem("Open...");
        this.fileOpen.addActionListener(this);
        this.fileSave = new JMenuItem("Save");
        this.fileSave.addActionListener(this);
        this.fileSaveAs = new JMenuItem("Save As...");
        this.fileSaveAs.addActionListener(this);
        this.fileGenerateFeatures = new JMenuItem("Generate Features");
        this.fileGenerateFeatures.addActionListener(this);
        this.fileGenerateImages = new JMenuItem("Generate Images");
        this.fileGenerateImages.addActionListener(this);
        this.fileGenerateFeaturesFromImages = new JMenuItem("Generate Features from Directory");
        this.fileGenerateFeaturesFromImages.addActionListener(this);
        this.fileExit = new JMenuItem("Exit");
        this.fileExit.addActionListener(this);
        jMenu.add(this.fileNew);
        jMenu.add(this.fileOpen);
        jMenu.add(this.fileSave);
        jMenu.add(this.fileSaveAs);
        jMenu.addSeparator();
        jMenu.add(this.fileGenerateFeatures);
        jMenu.add(this.fileGenerateFeaturesFromImages);
        jMenu.add(this.fileGenerateImages);
        jMenu.addSeparator();
        jMenu.add(this.fileExit);
        JMenu jMenu2 = new JMenu("Edit");
        this.editClear = new JMenuItem("Clear Windows");
        this.editClear.addActionListener(this);
        jMenu2.add(this.editClear);
        JMenu jMenu3 = new JMenu("Tools");
        this.toolsTest = new JMenuItem("Test Classifier");
        this.toolsTest.addActionListener(this);
        this.toolsGenerateBackgroundFeatures = new JMenuItem("Generate Background Features");
        this.toolsGenerateBackgroundFeatures.addActionListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(71, 2);
        this.toolsGenerateBackgroundFeatures.setAccelerator(keyStroke);
        jMenu3.add(this.toolsTest);
        jMenu3.add(this.toolsGenerateBackgroundFeatures);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WindowGUI.this.exit();
            }
        });
        this.setSize(800, 600);
        this.setVisible(true);
    }

    public Window getWindow() {
        return new Window(Integer.parseInt(this.windowWidth.getText()), Integer.parseInt(this.windowHeight.getText()), 0, 0, this.currentClass);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        if (actionEvent.getSource() == this.fileNew) {
            this.project = new WindowProject();
            this.currentImage = null;
            this.currentClass = null;
        }
        if (actionEvent.getSource() == this.fileOpen && (file = this.getFileOpen("Open Project", FileFilters.getWindowProjectFilter())) != null) {
            try {
                this.project = WindowProject.load(file);
                this.currentImage = this.project.getFirstImage();
                this.refresh();
                this.setStatus("Loaded project OK");
            }
            catch (Exception exception) {
                this.alert("Cannot open project: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        if (actionEvent.getSource() == this.fileSave) {
            if (this.project.getFile() == null) {
                this.saveAs();
            } else {
                try {
                    this.project.saveAs(this.project.getFile());
                    this.setStatus("Saved project OK");
                }
                catch (Exception exception) {
                    this.alert("Cannot save project: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        if (actionEvent.getSource() == this.fileGenerateFeatures) {
            this.generateFeatures();
        }
        if (actionEvent.getSource() == this.fileGenerateImages) {
            this.generateImages();
        }
        if (actionEvent.getSource() == this.fileGenerateFeaturesFromImages) {
            new FeaturesFromDirectory(this);
        }
        if (actionEvent.getSource() == this.toolsGenerateBackgroundFeatures) {
            try {
                for (int i = 0; i < this.project.images.size(); ++i) {
                    WindowImage windowImage;
                    this.currentImage = windowImage = this.project.images.elementAt(i);
                    this.generateBackgroundFeatures();
                }
            }
            catch (Exception exception) {
                this.alert(exception.toString());
                exception.printStackTrace();
            }
        }
        if (actionEvent.getSource() == this.fileSaveAs) {
            this.saveAs();
        }
        if (actionEvent.getSource() == this.fileExit) {
            this.exit();
        }
        if (actionEvent.getSource() == this.editClear) {
            if (this.currentImage != null) {
                int n = this.currentImage.clearWindows();
                this.setStatus("Cleared " + n + " windows");
            }
            this.refresh();
        }
        if (actionEvent.getSource() == this.toolsTest) {
            this.test(new PipelineClassifier());
        }
    }

    public void generateBackgroundFeatures() throws Exception {
        System.out.println("Generating background features");
        Vector<Window> vector = this.currentImage.getWindows();
        PixelLoader pixelLoader = this.currentImage.getPixelLoader();
        int n = 0;
        block0: while (n < 5) {
            int n2 = (int)(Math.random() * (double)pixelLoader.getWidth());
            int n3 = (int)(Math.random() * (double)pixelLoader.getWidth());
            int n4 = (int)(Math.random() * (double)pixelLoader.getHeight());
            int n5 = (int)(Math.random() * (double)pixelLoader.getHeight());
            int n6 = Math.min(n2, n3);
            int n7 = Math.max(n2, n3);
            int n8 = Math.min(n4, n5);
            int n9 = Math.max(n4, n5);
            int n10 = n7 - n6;
            int n11 = n9 - n8;
            int n12 = Math.min(n10, n11);
            Window window = new Window(n12, n12, n6, n8, this.project.getClassById(0));
            for (int i = 0; i < vector.size(); ++i) {
                double d;
                Window window2 = vector.elementAt(i);
                if (window2.getWindowClass().getClassID() == 0) continue;
                double d2 = (double)(window2.getWidth() * window2.getHeight()) * 0.5;
                double d3 = (double)(window2.getWidth() * window2.getHeight()) * 0.25;
                int n13 = 0;
                int n14 = 0;
                for (int j = window2.getY(); j <= window2.getY() + window2.getHeight(); ++j) {
                    for (int k = window2.getX(); k <= window2.getX() + window2.getWidth(); ++k) {
                        if (this.pixelWithinWindow(window, k, j)) {
                            ++n13;
                            continue;
                        }
                        ++n14;
                    }
                }
                if ((double)n13 < d3 || (double)n13 > d2 || (double)n13 < (d = (double)(window.getWidth() * window.getHeight()) * 0.25)) continue block0;
            }
            vector.add(window);
            ++n;
        }
        this.imagePanel.repaint();
    }

    public boolean pixelWithinWindow(Window window, int n, int n2) {
        return n >= window.getX() && n <= window.getX() + window.getWidth() && n2 >= window.getY() && n2 <= window.getY() + window.getHeight();
    }

    public void test(WindowClassifier windowClassifier) {
        if (this.currentImage == null) {
            this.alert("No image selected - cannot test.");
            return;
        }
        try {
            PixelLoader pixelLoader = this.currentImage.getPixelLoader();
            BufferedImage bufferedImage = new BufferedImage(pixelLoader.getWidth(), pixelLoader.getHeight(), 2);
            Graphics graphics = bufferedImage.getGraphics();
            Window window = this.getWindow();
            for (int i = 0; i < pixelLoader.getHeight() - window.getHeight(); ++i) {
                Window window2 = new Window(window.getWidth(), window.getHeight(), 0, i, null);
                window2.setClass(this.project.getClassById(windowClassifier.classify(pixelLoader, window2)));
                window2.drawRect(graphics);
            }
            new ImageFrame(bufferedImage);
        }
        catch (Exception exception) {
            this.alert("Can't load image");
        }
    }

    public void saveAs() {
        File file = this.getFileSave("Save Project As", FileFilters.getWindowProjectFilter());
        if (file != null) {
            try {
                this.project.saveAs(file);
                this.refresh();
                this.setStatus("Saved project OK");
            }
            catch (Exception exception) {
                this.alert("Cannot save project: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public void generateImages() {
        if (this.project == null) {
            this.alert("Please load a project first");
            return;
        }
        File file = this.fileTree.getCurrentDirectory();
        int n = 0;
        for (int i = 0; i < this.project.getImages().size(); ++i) {
            WindowImage windowImage = this.project.getImages().elementAt(i);
            try {
                PixelLoader pixelLoader = windowImage.getPixelLoader();
                for (int j = 0; j < windowImage.getWindows().size(); ++j) {
                    Window window = windowImage.getWindows().elementAt(j);
                    PixelLoader pixelLoader2 = pixelLoader.getSubImage(new ImageWindow(window));
                    String string = window.getWindowClass().getName();
                    File file2 = new File(file, string);
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    pixelLoader2.saveAs(new File(file2, "image" + n + ".bmp"));
                    ++n;
                }
                continue;
            }
            catch (Exception exception) {
                this.alert("Cannot load image for processing: " + windowImage.getFile().getAbsolutePath());
                exception.printStackTrace();
            }
        }
        this.alert("Created " + n + " window images");
    }

    public void generateFeatures() {
        File file = this.getFileSave("Save Features", FileFilters.getCSVFilter());
        if (file != null) {
            CSVWriter cSVWriter = new CSVWriter();
            this.project.clearUnusedImages();
            int n = 0;
            for (int i = 0; i < this.project.getImages().size(); ++i) {
                WindowImage windowImage = this.project.getImages().elementAt(i);
                try {
                    PixelLoader pixelLoader = windowImage.getPixelLoader();
                    for (int j = 0; j < windowImage.getWindows().size(); ++j) {
                        Window window = windowImage.getWindows().elementAt(j);
                        double[] dArray = WindowFeatures.getFeatures(pixelLoader, window);
                        cSVWriter.addData(dArray);
                        cSVWriter.addData(window.getWindowClass().getClassID());
                        cSVWriter.newLine();
                        ++n;
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.alert("Cannot load image: " + windowImage.getFile().getAbsolutePath());
                    exception.printStackTrace();
                }
            }
            try {
                cSVWriter.save(file);
                this.status.setText("Saved " + n + " features");
            }
            catch (Exception exception) {
                this.alert("Cannot save CSV file");
                exception.printStackTrace();
            }
        }
    }

    public void exit() {
        System.exit(0);
    }

    private File getFileSave(String string, FileFilter fileFilter) {
        this.fc.setDialogTitle(string);
        this.fc.setFileFilter(fileFilter);
        int n = this.fc.showSaveDialog(this);
        if (n == 0) {
            return this.fc.getSelectedFile();
        }
        return null;
    }

    private File getFileOpen(String string, FileFilter fileFilter) {
        this.fc.setDialogTitle(string);
        this.fc.setFileFilter(fileFilter);
        int n = this.fc.showOpenDialog(this);
        if (n == 0) {
            return this.fc.getSelectedFile();
        }
        return null;
    }

    public void alert(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public void refresh() {
        this.imagePanel.currentWindow = null;
        this.display(this.currentImage);
        if (this.project.file != null) {
            this.setTitle("Window GUI (In Development) - " + this.project.file.getName());
        } else {
            this.setTitle(APP_NAME);
        }
    }

    public void display(WindowImage windowImage) {
        if (windowImage == null) {
            this.imagePanel.setImageNull();
        } else {
            try {
                this.imagePanel.setImage(new PixelLoader(windowImage.getFile()));
            }
            catch (Exception exception) {
                this.alert("Cannot load image: " + windowImage.getFile());
                exception.printStackTrace();
            }
        }
    }

    public void selectFile(File file) {
        this.currentImage = this.project.getImageByFile(file);
        if (this.currentImage == null) {
            this.currentImage = new WindowImage(file);
            this.project.addImage(this.currentImage);
        }
        this.refresh();
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }

    class EasyComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selectedObject = null;

        public EasyComboModel() {
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selectedObject = object;
            WindowGUI.this.currentClass = (WindowClass)object;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public Object getElementAt(int n) {
            if (WindowGUI.this.project.classes != null && n >= 0 && n <= this.getSize()) {
                return WindowGUI.this.project.classes.elementAt(n);
            }
            return null;
        }

        @Override
        public int getSize() {
            if (WindowGUI.this.project.classes != null) {
                return WindowGUI.this.project.classes.size();
            }
            return 0;
        }
    }

    class ClassButton
    extends JButton {
        public ClassButton(final WindowClass windowClass) {
            super(windowClass.getName());
            this.setBackground(windowClass.getColor());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WindowGUI.this.currentClass = windowClass;
                }
            });
        }
    }
}

