/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.window;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.panels.ImagePanel;
import ac.essex.ooechs.imaging.commons.window.WindowGUI;
import ac.essex.ooechs.imaging.commons.window.data.Window;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class WindowImagePanel
extends ImagePanel {
    public Window currentWindow;
    public WindowGUI gui;
    int x1;
    int y1;

    public WindowImagePanel(final WindowGUI windowGUI) {
        this.gui = windowGUI;
        this.setDisplayCentered(true);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (windowGUI.currentClass == null) {
                    return;
                }
                if (WindowImagePanel.this.image == null) {
                    return;
                }
                if (windowGUI.mode == 1) {
                    WindowImagePanel.this.currentWindow = windowGUI.getWindow();
                    int n = WindowImagePanel.this.getX(mouseEvent);
                    int n2 = WindowImagePanel.this.getY(mouseEvent);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n + WindowImagePanel.this.currentWindow.width > WindowImagePanel.this.image.getWidth()) {
                        n = WindowImagePanel.this.image.getWidth() - WindowImagePanel.this.currentWindow.width;
                    }
                    if (n2 + WindowImagePanel.this.currentWindow.height > WindowImagePanel.this.image.getHeight()) {
                        n2 = WindowImagePanel.this.image.getHeight() - WindowImagePanel.this.currentWindow.height;
                    }
                    WindowImagePanel.this.currentWindow.x = n;
                    WindowImagePanel.this.currentWindow.y = n2;
                    windowGUI.setStatus("X: " + n + ", Y: " + n2);
                    WindowImagePanel.this.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (windowGUI.mode == 2) {
                    int n = WindowImagePanel.this.getX(mouseEvent);
                    int n2 = WindowImagePanel.this.getY(mouseEvent);
                    int n3 = Math.min(WindowImagePanel.this.x1, n);
                    int n4 = Math.max(WindowImagePanel.this.x1, n);
                    int n5 = Math.min(WindowImagePanel.this.y1, n2);
                    int n6 = Math.max(WindowImagePanel.this.y1, n2);
                    int n7 = n4 - n3;
                    int n8 = n6 - n5;
                    WindowImagePanel.this.currentWindow = new Window(n7, n8, n3, n5, windowGUI.currentClass);
                    windowGUI.setStatus("X: " + mouseEvent.getX() + ", Y: " + mouseEvent.getY());
                    WindowImagePanel.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                WindowImagePanel.this.x1 = WindowImagePanel.this.getX(mouseEvent);
                WindowImagePanel.this.y1 = WindowImagePanel.this.getY(mouseEvent);
                System.out.println("Mouse down: " + WindowImagePanel.this.x1 + ", " + WindowImagePanel.this.y1);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (windowGUI.currentClass == null) {
                    return;
                }
                if (WindowImagePanel.this.image == null) {
                    return;
                }
                windowGUI.currentImage.addWindow(WindowImagePanel.this.currentWindow);
            }
        });
    }

    @Override
    public void setImage(PixelLoader pixelLoader) {
        this.currentWindow = null;
        super.setImage(pixelLoader);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.gui.currentImage != null) {
            for (int i = 0; i < this.gui.currentImage.getWindows().size(); ++i) {
                Window window = this.gui.currentImage.getWindows().elementAt(i);
                this.drawRect(graphics, window);
            }
        }
        if (this.currentWindow != null) {
            this.drawRect(graphics, this.currentWindow);
        }
    }

    public void drawRect(Graphics graphics, Window window) {
        graphics.setColor(window.getWindowClass().getColor());
        graphics.drawRect(window.x + this.offsetX, window.y + this.offsetY, window.width * this.zoom, window.height * this.zoom);
    }
}

