/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.window.data;

import ac.essex.ooechs.imaging.commons.window.data.WindowClass;
import ac.essex.ooechs.imaging.commons.window.data.WindowImage;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class WindowProject
implements Serializable {
    public Vector<WindowImage> images = new Vector();
    public Vector<WindowClass> classes = new Vector();
    public File file = null;

    public WindowProject() {
        this.classes.add(new WindowClass("Background", 0, Color.RED));
        this.classes.add(new WindowClass("Foreground", 1, Color.GREEN));
    }

    public WindowClass getClassById(int n) {
        for (int i = 0; i < this.classes.size(); ++i) {
            WindowClass windowClass = this.classes.elementAt(i);
            if (windowClass.getClassID() != n) continue;
            return windowClass;
        }
        return null;
    }

    public static WindowProject load(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        WindowProject windowProject = (WindowProject)objectInputStream.readObject();
        objectInputStream.close();
        if (windowProject.images == null) {
            windowProject.images = new Vector();
            windowProject.file = file;
        }
        return windowProject;
    }

    public Vector<WindowImage> getImages() {
        return this.images;
    }

    public Vector<WindowClass> getClasses() {
        return this.classes;
    }

    public WindowImage getFirstImage() {
        if (this.images.size() > 0) {
            return this.images.elementAt(0);
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public WindowImage getImageByFile(File file) {
        for (int i = 0; i < this.images.size(); ++i) {
            WindowImage windowImage = this.images.elementAt(i);
            if (!windowImage.getFile().equals(file)) continue;
            return windowImage;
        }
        return null;
    }

    public void addImage(WindowImage windowImage) {
        if (!this.images.contains(windowImage)) {
            this.images.add(windowImage);
        }
    }

    public void clearUnusedImages() {
        Vector<WindowImage> vector = new Vector<WindowImage>();
        for (int i = 0; i < this.images.size(); ++i) {
            WindowImage windowImage = this.images.elementAt(i);
            if (windowImage.countWindows() != 0) continue;
            vector.add(windowImage);
        }
        this.images.removeAll(vector);
    }

    public void saveAs(File file) throws IOException {
        this.clearUnusedImages();
        this.file = file;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }
}

