/*
 * Decompiled with CFR 0.152.
 */
package ac.essex.ooechs.imaging.commons.window.util;

import ac.essex.ooechs.imaging.commons.PixelLoader;
import ac.essex.ooechs.imaging.commons.util.CSVWriter;
import ac.essex.ooechs.imaging.commons.window.WindowGUI;
import ac.essex.ooechs.imaging.commons.window.data.Window;
import ac.essex.ooechs.imaging.commons.window.util.WindowFeatures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class FeaturesFromDirectory
extends JDialog
implements ActionListener {
    JTextField classID;
    JTextField directory;
    JTextArea output;
    JButton process;
    JButton close;
    WindowGUI owner;

    public FeaturesFromDirectory(WindowGUI windowGUI) {
        super(windowGUI);
        this.setTitle("Generate Features From Images");
        this.owner = windowGUI;
        this.directory = new JTextField(windowGUI.fileTree.getCurrentDirectory().getAbsolutePath());
        this.process = new JButton("Process");
        this.classID = new JTextField("0");
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.directory, "Center");
        jPanel.add((Component)this.classID, "West");
        jPanel.add((Component)this.process, "East");
        this.process.addActionListener(this);
        this.output = new JTextArea("");
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "North");
        container.add((Component)new JScrollPane(this.output), "Center");
        container.add((Component)this.close, "South");
        this.setSize(400, 300);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        if (actionEvent.getSource() == this.close) {
            this.dispose();
        }
        if (actionEvent.getSource() == this.process && (file = new File(this.directory.getText())).exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            CSVWriter cSVWriter = new CSVWriter();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                try {
                    PixelLoader pixelLoader = new PixelLoader(file2);
                    Window window = new Window(pixelLoader.getWidth(), pixelLoader.getHeight(), 0, 0, null);
                    double[] dArray = WindowFeatures.getFeatures(pixelLoader, window);
                    cSVWriter.addData(dArray);
                    cSVWriter.addData(Integer.parseInt(this.classID.getText()));
                    cSVWriter.newLine();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.output.setText(cSVWriter.toString());
        }
    }
}

